# to autoload this file
proc m2Syntax.tcl {} {}


namespace eval M2 {}


 
#===========================================================================
#  RESERVED WORDS  #
#===========================================================================
# Reserved words needed by jumpToTemplatePlaceHolder for proper, case sensitive functioning 
# and indentations. returnCompleteWords get special treatment, i.e. moving cursor within line
set returnCompleteWords "FOR FROM IF"      
set returnWords "$returnCompleteWords BEGIN CONST ELSE ELSIF THEN WHILE PROCEDURE WITH" 
set returnWords "$returnWords MODULE REPEAT LOOP TYPE VAR"

# Reserved words automatically triggering a template if a <space bar> is typed afterwards
set spaceWords  "CASE WHILE FOR IF if ELSIF REPEAT FROM PROCEDURE IMPLEMENTATION DEFINITION LOOP MODULE WITH"

# Reserved words automatically expandable by Cmd^Tab or ESC <space bar>
set expandWords "ARRAY BOOLEAN BITSET BY CARDINAL CHAR DO END LONGCARD LONGINT LONGREAL"
# PROC is on purpose omitted cos' of conflict with PROCEDURE
set expandWords " $expandWords IMPORT EXPORT INTEGER OF POINTER REAL RECORD RETURN TO UNTIL"
set expandWords [lsort "$returnWords $spaceWords $expandWords"]
# FALSE and TRUE have on purpose been omitted from above list

# Reserved words which can trigger template by <space bar> or be expanded by M2Completions.tcl
set doubleDefinedWords {if}

# Standard procedures (predefined, some may be overloaded)
set standardProcs "ABS CAP CHR FLOAT HIGH ODD ORD TRUNC DEC EXCL HALT INC INCL NEW DISPOSE"
# VAL has on purpose been omitted from above list 



#===========================================================================
#  Colorization  #
#===========================================================================
proc M2::colorizing {args} {
    global M2modeVars
    global expandWords
    global standardProcs
    regModeKeywords -k $M2modeVars(keywordColor) \
      -b {(*} {*)} -c $M2modeVars(commentColor) \
      -s $M2modeVars(stringColor) \
      M2 $expandWords
    regModeKeywords -a -k $M2modeVars(standardProcColor) \
      M2 $standardProcs
}

# Activate it
M2::colorizing


# Reporting that end of this script has been reached
message "m2Syntax.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
	alertnote "m2Syntax.tcl for Programing in Modula-2 loaded"
}
